require "DebugUIs/DebugMenu/Base/ISDebugSubPanelBase"

TABAS_StatsDebug = ISDebugSubPanelBase:derive("TABAS_StatsDebug")

local FONT_HGT_SMALL = getTextManager():getFontHeight(UIFont.Small)
local UI_BORDER_SPACING = 10
local BUTTON_HGT = FONT_HGT_SMALL + 6
local SCROLL_BAR_WIDTH = 13

function TABAS_StatsDebug:initialise()
    ISPanel.initialise(self)
end

local function getBodyBloodOrDirt(var)
    local visual = getPlayer():getHumanVisual()
    local total = 0
    local maxIndex = BloodBodyPartType.MAX:index()
    if var == "Blood" then
        for i=1, maxIndex do
            local part = BloodBodyPartType.FromIndex(i-1)
            total = total + visual:getBlood(part)
        end
    elseif var == "Dirt" then
        for i=1, maxIndex do
            local part = BloodBodyPartType.FromIndex(i-1)
            total = total + visual:getDirt(part)
        end
    end
    return math.ceil(total / BloodBodyPartType.MAX:index() * 100)
end

function TABAS_StatsDebug:createChildren()
    ISPanel.createChildren(self)

    local x,y,w = UI_BORDER_SPACING+1,UI_BORDER_SPACING+1,self.width-UI_BORDER_SPACING*2 - SCROLL_BAR_WIDTH - 1

    self:initHorzBars(x,w)

    local obj
    y, obj = ISDebugUtils.addLabel(self,"float_title",x+(w/2),y,"Take A Bath And Shower Debug", UIFont.Medium)
    obj.center = true
    y, obj = ISDebugUtils.addLabel(self,"float_title",x+(w/2),y,"Items marked with (*) cannot be changed manually.", UIFont.Small)
    obj.center = true

    y = ISDebugUtils.addHorzBar(self,y+UI_BORDER_SPACING)+UI_BORDER_SPACING+1

    local player = getPlayer()
    local body = player:getBodyDamage()
    self.modData = player:getModData()

    self.sliderOptions = {}
    self.boolOptions = {}

    self:addSliderOption("mod", "BodyGrime", 0, 100, 0.1, true)
    self:addSliderOption(nil, "Blood", 0, 100, false)
    self:addSliderOption(nil, "Dirt", 0, 100, false)
    self:addSliderOption("mod","bathingWetTimer", 0, 3600, 1, true)
    self:addSliderOption("mod","afterBathing", 0, 1, 0.001, true)
    self:addSliderOption(body, "Wetness", 0, 100, 1, true)
    self:addSliderOption("mod", "bathBenefitedLimit", 0, 100, 1, true)

    self:addBoolOption("mod", "isBathing", true)

    self:addSliderOption(player, "BetaEffect", 0, 10000, 1, true)
    self:addSliderOption(player, "DepressEffect", 0, 10000, 1, true)
    self:addSliderOption(player, "PainEffect", 0, 10000, 1, true)
    self:addSliderOption(player, "SleepingTabletEffect", 0, 10000, 1, true)


    local barMod = UI_BORDER_SPACING
    local y2, label, value, slider
    for i=1, #self.sliderOptions do
        local v = self.sliderOptions[i]
        local text = v.manually and v.var or v.var .. " (*)"
        y2,label = ISDebugUtils.addLabel(self,v,x,y,text, UIFont.Small)

        y2,value = ISDebugUtils.addLabel(self,v,x+(w-300)-20,y,"0", UIFont.Small, false)
        y,slider = ISDebugUtils.addSlider(self,v,x+(w-300),y,300, BUTTON_HGT, TABAS_StatsDebug.onSliderChange)
        slider.valueLabel = value

        v.label = label
        v.labelValue = value
        v.slider = slider
        
        slider:setValues(v.min, v.max, v.step, v.step, true)
        local val
        if v.var == "Blood" or v.var == "Dirt" then
            val = getBodyBloodOrDirt(v.var)
        elseif v.java == "mod" then
            val = self.modData[v.var] or 0
        else
            val = v.java[v.get](v.java)
        end
        slider:setCurrentValue(val)

        y = ISDebugUtils.addHorzBar(self,math.max(y,y2)+barMod)+barMod+1
    end

    local tickbox
    for i=1, #self.boolOptions do
        local v=self.boolOptions[i]
        y2,label = ISDebugUtils.addLabel(self,v,x,y,v.var, UIFont.Small)

        local tickOptions = {}
        table.insert(tickOptions, { text = getText("IGUI_DebugMenu_Enabled") , ticked = false })
        y,tickbox = ISDebugUtils.addTickBox(self,v,x+(w-300),y,300,BUTTON_HGT,v.var,tickOptions,TABAS_StatsDebug.onTicked)

        v.label = label
        v.tickbox = tickbox

        y = ISDebugUtils.addHorzBar(self,y+barMod)+barMod+1
    end

    self:setScrollHeight(y+1)
end

function TABAS_StatsDebug:addSliderOption(_java, _var, _min, _max, _step, _manually, _get, _set)
    local option = {
        java = _java,
        var = _var,
        min = _min,
        max = _max,
        step = _step or 0.01,
        manually = _manually,
        get = _get or ("get" .. _var),
        set = _set or ("set" .. _var),
    }
    table.insert(self.sliderOptions,option)
    return option
end

function TABAS_StatsDebug:addBoolOption(_java, _var, _manually, _get, _set)
    local bool = {
        java = _java,
        var = _var,
        manually = _manually,
        get = _get or ("get" .. _var),
        set = _set or ("set" .. _var),
    }
    table.insert(self.boolOptions,bool)
    return bool
end

function TABAS_StatsDebug:prerender()
    ISDebugSubPanelBase.prerender(self)

    local val
    for i=1,#self.sliderOptions do
        local v= self.sliderOptions[i]
        if v.var == "Blood" or v.var == "Dirt" then
            val = getBodyBloodOrDirt(v.var)
        elseif v.java == "mod" then
            val = self.modData[v.var] or 0
        else
            val = v.java[v.get](v.java)
        end
        v.slider.currentValue = val
        if v.slider.pretext then
            v.labelValue:setName(v.slider.pretext..ISDebugUtils.printval(val,3))
        else
            v.labelValue:setName(ISDebugUtils.printval(val,3))
        end
    end

    for i=1, #self.boolOptions do
        local v = self.boolOptions[i]
        val = self.modData[v.var]
        v.tickbox.selected[1] = val
    end
end

function TABAS_StatsDebug:onSliderChange(_newval, _slider)
    local v = _slider.customData
    if not v.manually then return end
    if v.java == "mod" then
        self.modData[v.var] = _newval
    else
        v.java[v.set](v.java, _newval)
    end
end

function TABAS_StatsDebug:onTicked(_index, _selected, _arg1, _arg2, _tickbox)
    local v = _tickbox.customData
    if not v.manually then return end
    if v.java == "mod" then
        self.modData[v.var] = not self.modData[v.var]
    else
        v.java[v.set](v.java, not v.java[v.get](v.java))
    end
end

function TABAS_StatsDebug:update()
    ISPanel.update(self)
end

function TABAS_StatsDebug:new(x, y, width, height, doStencil)
    local o = {}
    o = ISDebugSubPanelBase:new(x, y, width, height, doStencil)
    setmetatable(o, self)
    self.__index = self
    return o
end

